package com.company.tp07_04_remotetodoapp2.repository;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.lifecycle.MutableLiveData;

import com.company.tp07_04_remotetodoapp2.remote.Todo;
import com.company.tp07_04_remotetodoapp2.remote.retrofit.RetrofitApiInterface;
import com.company.tp07_04_remotetodoapp2.remote.retrofit.RetrofitClientInstance;

import java.util.List;

import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;


public class TodoRepo {

    private MutableLiveData<List<Todo>> todoList;
    private static TodoRepo instance;

    public static TodoRepo getInstance(Application application){
        if(instance==null){
            instance = new TodoRepo();
        }
        return instance;
    }

    private TodoRepo() {
        todoList = new MutableLiveData<List<Todo>>();
        RetrofitApiInterface service = RetrofitClientInstance.getRetrofitApiInterface();
        Observable<List<Todo>> observable = service.getTodoList();
        Observer<List<Todo>> observer = new Observer<List<Todo>>() {
            @Override
            public void onSubscribe(@NonNull Disposable d) {
            }
            @Override
            public void onNext(@NonNull List<Todo> todos) {
                todoList.setValue(todos);
            }
            @Override
            public void onError(@NonNull Throwable e) {
            }
            @Override
            public void onComplete() {
            }
        };
        observable
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribeWith(observer);
    }
    public MutableLiveData<List<Todo>> getTodoList() {
        return todoList;
    }

}
